use[JasmineLocal]
Go

ALTER VIEW [dbo].[OrdersMasterView]
AS
SELECT Master_ID
,OM.Customer_ID
,OM.Restaurant_ID
,OM.Outlet_ID
,Order_Seq
,Order_Kind
,OrdersKinds.Kind_Desc_PL AS Order_Kind_Desc
,Order_Origin
,Working_Date
,Open_DateTime
,Close_DateTime
,Waiter_Name
,Cashier_Name
,Address_ID
,Driver_Name
,Company_ID
,DT_ID
,Financial_Status
,Kitchen_Status
,Order_PayOption
,Order_Upper_Line
,Order_Downer_Line
,Master_Remarks
,Order_ItemsQty
,Value_Grand
,Delivery_Charges
,Value_With_Delivery_Charges
,Discount
,Value_After_Discount
,Tax_VAT
,Value_Net      
,Customer_Cash
,Customer_Change
,Order_Covers
,Order_Selective_TAX
,Order_Tips
,Tentative_Cost
,OM.Account_ID
,Discount_Remarks
,DC_Customer_Name
,DC_Customer_Mobile
FROM  dbo.OrdersMaster AS OM  
Left Outer Join OrdersKinds
On OM.Order_Kind = OrdersKinds.Kind_ID
GO

IF COL_LENGTH('AfterKitchenVoids','isUploaded') IS NULL
begin
  Alter Table AfterKitchenVoids add [isUploaded][bit] null, [Uploaded_DateTime][datetime] null;
  Alter Table OrdersMaster add [isUploaded][bit] null, [Uploaded_DateTime][datetime] null;
  Alter Table ReOpenedOrders add [isUploaded][bit] null, [Uploaded_DateTime][datetime] null;
end
Go

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CustomersCOA]') AND type in (N'U'))
CREATE TABLE [dbo].[CustomersCOA](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Account_ID] [bigint] NOT NULL,
	[Parent_ID] [bigint] NOT NULL,
	[Group_ID] [bigint] NOT NULL,
	[Account_Name] [nvarchar](255) NOT NULL,
	[Account_Name_SL] [nvarchar](255) NULL,
	[Account_Nature] [nvarchar](50) NOT NULL,
	[Remarks] [nvarchar](255) NULL,
	[isActive] [bit] NOT NULL,
	[isProtected] [bit] NOT NULL,
	[CanAddChild] [bit] NOT NULL,
 CONSTRAINT [PK_CustomersCOA] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Account_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
Go

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeliveryCompanies]') AND type in (N'U'))
CREATE TABLE [dbo].[DeliveryCompanies](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Company_ID] [bigint] NOT NULL,
	[Company_Name] [nvarchar](50) NOT NULL,
	[isActive] [bit] NOT NULL,
	[Receivables_Account] [bigint] NOT NULL,
	[Expenses_Account] [bigint] NOT NULL,
	[Per_Order_Percentage] [decimal](6, 3) NOT NULL,
	[Per_Order_Fixed] [decimal](6, 3) NOT NULL,
	[Per_Order_Minimum] [decimal](6, 3) NOT NULL,
	[Remarks] [nvarchar](255) NULL,
 CONSTRAINT [PK_DeliveryCompanies] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Company_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
Go

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


ALTER   VIEW [dbo].[OrdersDetailsStationsView]
AS
SELECT [Customer_ID]
,[Restaurant_ID]
,[Outlet_ID]
,[Master_ID]
,[Detail_ID]
,[Working_Date]
,[Added_DateTime]
,[Added_By]
,[Sent_DateTime]
,[Sent_By]
,[Category_Kind]
,[Category_ID]
,[Item_ID]
,[Item_Name_PL]
,[Item_Name_SL]
,[Item_Cost]
,[Item_Price]
,[Item_Selective_Tax_Amount]
,[Item_TaxedPrice]
,[Item_Qty]
,[withRemarks]
,[Remarks]
,[AddOns_IDs]
,[AddOns_Names_PL]
,[AddOns_Names_SL]
,[Seat_No]
,[isComplementary]
,[isCustody]
,[isPrinted]
,[isServed]
,[isVoided]
,[Voided_By]
,[Revenue_Account]
,[Expenses_Account]
,[isSent]
,[Cost_Policy]
,[Recipe_ID]
,[RawItem_ID]
,Concat(Item_Name_PL, Case When AddOns_Names_PL='' then null else CHAR(13)+CHAR(10) + N'Add-Ons:' + NullIF(Replace(AddOns_Names_PL, '#', CHAR(13)+CHAR(10)), '') end) Displayed_Name_PL
,Concat(Item_Name_SL, Case When AddOns_Names_SL='' then null else CHAR(13)+CHAR(10) + N':' + NullIF(Replace(AddOns_Names_SL, '#', CHAR(13)+CHAR(10)), '') end) Displayed_Name_SL
FROM [dbo].[OrdersDetails]
GO

